package parser;

/**
 * Grammar non-terminal -- T1a ::= * T
 */
public class T1a implements T1 {
    /**
     * Multiply object.
     */
    private MultToken _mult;

    /**
     * T object.
     */
    private T _t;

    /**
     * Constructor for the T1a grammar non-terminal.
     *
     * @param mult mult object
     * @param t    T object
     */
    public T1a(MultToken mult, T t) {
        _mult = mult;
        _t = t;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _mult.toString() + _t.toString();
    }
}

